package com.ejie.ab18a.service;

import com.ejie.ab18a.dao.Ab18aLinksPublicacionDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aLinksPublicacion;

/**
 * Ab18aLinksPublicacionServiceImpl generated by XXXX, 03-feb-2017 12:08:05.
 * 
 * @author XXXX
 */

@Service(value = "ab18a08s00Service")
public class Ab18aLinksPublicacionServiceImpl implements
		Ab18aLinksPublicacionService {

	@Autowired
	private Ab18aLinksPublicacionDao linkPublicacionDao;

	/**
	 * Inserts a single row in the Ab18a08s00 table.
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 * @return Ab18a08s00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ab18aLinksPublicacion add(Ab18aLinksPublicacion linkPublicacion) {
		return this.linkPublicacionDao.add(linkPublicacion);
	}

	/**
	 * Updates a single row in the Ab18a08s00 table.
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 * @return Ab18a08s00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ab18aLinksPublicacion update(Ab18aLinksPublicacion linkPublicacion) {
		return this.linkPublicacionDao.update(linkPublicacion);
	}

	/**
	 * Finds a single row in the Ab18a08s00 table.
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 * @return Ab18a08s00
	 */
	public Ab18aLinksPublicacion find(Ab18aLinksPublicacion linkPublicacion) {
		return (Ab18aLinksPublicacion) this.linkPublicacionDao
				.find(linkPublicacion);
	}

	/**
	 * Deletes a single row in the Ab18a08s00 table.
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Ab18aLinksPublicacion linkPublicacion) {
		this.linkPublicacionDao.remove(linkPublicacion);
	}

	/**
	 * Finds a list of rows in the Ab18a08s00 table.
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a08s00>
	 */
	public List<Ab18aLinksPublicacion> findAll(
			Ab18aLinksPublicacion linkPublicacion,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Ab18aLinksPublicacion>) this.linkPublicacionDao.findAll(
				linkPublicacion, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab18a08s00 table using like.
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a08s00>
	 */
	public List<Ab18aLinksPublicacion> findAllLike(
			Ab18aLinksPublicacion linkPublicacion,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Ab18aLinksPublicacion>) this.linkPublicacionDao
				.findAllLike(linkPublicacion, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab18a08s00 table.
	 * 
	 * @param filterAb18a08s00
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Ab18aLinksPublicacion filterAb18a08s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.linkPublicacionDao.removeMultiple(filterAb18a08s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab18a08s00 table.
	 * 
	 * @param filterAb18a08s00
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Ab18a08s00>
	 */
	public JQGridResponseDto<Ab18aLinksPublicacion> filter(
			Ab18aLinksPublicacion filterAb18a08s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Ab18aLinksPublicacion> listaAb18a08s00 = this.linkPublicacionDao
				.findAllLike(filterAb18a08s00, jqGridRequestDto, false);
		Long recordNum = this.linkPublicacionDao.findAllLikeCount(
				filterAb18a08s00 != null ? filterAb18a08s00
						: new Ab18aLinksPublicacion(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Ab18aLinksPublicacion>> reorderSelection = this.linkPublicacionDao
					.reorderSelection(filterAb18a08s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Ab18aLinksPublicacion>(
					jqGridRequestDto, recordNum, listaAb18a08s00,
					reorderSelection);
		}
		return new JQGridResponseDto<Ab18aLinksPublicacion>(jqGridRequestDto,
				recordNum, listaAb18a08s00);
	}

	/**
	 * Searches rows in the Ab18a08s00 table.
	 * 
	 * @param filterAb18a08s00
	 *            Ab18a08s00
	 * @param searchAb18a08s00
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a08s00>>
	 */
	public List<TableRowDto<Ab18aLinksPublicacion>> search(
			Ab18aLinksPublicacion filterAb18a08s00,
			Ab18aLinksPublicacion searchAb18a08s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.linkPublicacionDao.search(filterAb18a08s00,
				searchAb18a08s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab18a08s00 table.
	 * 
	 * @param filterAb18a08s00
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Ab18aLinksPublicacion filterAb18a08s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.linkPublicacionDao.reorderSelection(filterAb18a08s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab18a08s00 table.
	 * 
	 * @param filterAb18a08s00
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a08s00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Ab18aLinksPublicacion>> jerarquia(
			Ab18aLinksPublicacion filterAb18a08s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<JerarquiaDto<Ab18aLinksPublicacion>> listaAb18a08s00 = this.linkPublicacionDao
				.findAllLikeJerarquia(filterAb18a08s00, jqGridRequestDto);
		Long recordNum = this.linkPublicacionDao.findAllLikeCountJerarquia(
				filterAb18a08s00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Ab18aLinksPublicacion>>(
				jqGridRequestDto, recordNum, listaAb18a08s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Ab18a08s00 table.
	 * 
	 * @param filterAb18a08s00
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a08s00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Ab18aLinksPublicacion>> jerarquiaChildren(
			Ab18aLinksPublicacion filterAb18a08s00,
			JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Ab18aLinksPublicacion>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Ab18aLinksPublicacion>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.linkPublicacionDao.findAllChild(filterAb18a08s00,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

}
